/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public final class VWXMLUtil {
    protected static final String NameSpace = "http://filenet.com/namespaces/apps/eprocess/runtime/1.0";
    protected static final String RtBlockHeader = "<?xml version='1.0'?>\n<eProcessRtXML xmlns=\"http://filenet.com/namespaces/apps/eprocess/runtime/1.0\">\n";
    protected static final String RtBlockTail = "</eProcessRtXML>\n";
    protected static final String UTC_ISO_DateMask = "yyyyMMdd'T'HHmmss'Z'";
    protected static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    protected static SimpleTimeZone pdt = new SimpleTimeZone(0, "UTC");
    private static final Long NO_DATE = new Long("-2000000000000");

    public static String _get_FILE_DATE() {
        return "$Date: 2010-01-08 20:36:37 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/1 $";
    }

    public static String makeXMLBlock(IVWtoXML[] apiObjects, String theGroupTag) throws VWException {
        StringBuffer tmpSBuf = new StringBuffer();
        tmpSBuf.append(RtBlockHeader);
        if (theGroupTag != null) {
            tmpSBuf.append("<" + theGroupTag + ">\n");
        }
        if (apiObjects != null) {
            for (int i = 0; i < apiObjects.length; ++i) {
                if (apiObjects[i] == null) continue;
                apiObjects[i].toXML(tmpSBuf);
            }
        }
        if (theGroupTag != null) {
            tmpSBuf.append("</" + theGroupTag + ">\n");
        }
        tmpSBuf.append(RtBlockTail);
        return tmpSBuf.toString();
    }

    public static String makeXMLBlock(IVWtoXML apiObject) throws VWException {
        IVWtoXML[] tmpArr = null;
        if (apiObject != null) {
            tmpArr = new IVWtoXML[]{apiObject};
        }
        return VWXMLUtil.makeXMLBlock(tmpArr, null);
    }

    public static String getNameSpace() {
        return NameSpace;
    }

    public static void setDatePattern(String pattern) throws VWException {
        sdf.applyPattern(pattern);
    }

    public static void setDateTimeZone(SimpleTimeZone TZone) throws VWException {
        pdt = TZone;
    }

    protected static String convertDateToUTCString(Date theDate) {
        if (theDate == null || theDate.getTime() == NO_DATE.longValue()) {
            return "";
        }
        sdf.setTimeZone(pdt);
        String strDate2 = sdf.format(theDate);
        return strDate2;
    }

    protected static Date convertUTCStringToDate(String theDateStr) {
        if (theDateStr == null || theDateStr.length() == 0) {
            return null;
        }
        Date retDate = null;
        sdf.setTimeZone(pdt);
        try {
            retDate = sdf.parse(theDateStr, new ParsePosition(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retDate;
    }
}

